package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;
import java.util.Set;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDataSource extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {

		try {
			DataSource.findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<DataSource> dataSourceList = DataSource.listAll();
		 
		Assert.assertNotNull(dataSourceList);
		Assert.assertTrue(dataSourceList.size() > 0);
		 
	}
	
	@Test
	public void testThree() throws Exception {

		// find somebody to search for
		List<DataSource> dataSourceList = DataSource.listAll();
		 
		Assert.assertNotNull(dataSourceList);
		Assert.assertTrue(dataSourceList.size() > 0);
		 
		DataSource ds = DataSource.findById(dataSourceList.get(0).getId());
		Assert.assertNotNull(ds);
		Assert.assertTrue(dataSourceList.get(0).equals(ds));
	
		Assert.assertNotNull(ds.getDomainName());
		Assert.assertNotNull(ds.getEvaluator());
		Assert.assertNotNull(ds.getDescription());
		Assert.assertNotNull(ds.getName());
		Assert.assertNotNull(ds.getInfoSite());
		Assert.assertNotNull(ds.getDocumentTemplates());
		Assert.assertTrue(ds.getDocumentTemplates().size() > 0);
	}

	@Test
	public void testTwo() throws Exception {

		List<DataSource> dataSourceList = DataSource.findByDocumentTemplateId(-1);
		Assert.assertNotNull(dataSourceList);
		Assert.assertEquals(dataSourceList.size(), 0);

		// find somebody to search for
		dataSourceList =DataSource.listAll();
		 
		Assert.assertNotNull(dataSourceList);
		Assert.assertTrue(dataSourceList.size() > 0);
		 
		DataSource ds = dataSourceList.get(0);
		Assert.assertNotNull(ds);

		Set<DocumentTemplate> dtSet = ds.getDocumentTemplates();
		
		Assert.assertNotNull(dtSet);
		
		// there may not be any document templates associated with this data source.
		if (dtSet.size() > 0) {
			Assert.assertTrue(dtSet.size() > 0);
			 
			DocumentTemplate dt = (DocumentTemplate)dtSet.iterator().next();
			Assert.assertNotNull(dt);
			Assert.assertTrue(dt.getId() > 0);
			 
			List<DataSource> dsList = DataSource.findByDocumentTemplateId(dt.getId());
			Assert.assertNotNull(dsList);
			Assert.assertTrue(dsList.size() > 0);
			
			for (DataSource ds2 : dsList) {
				Assert.assertTrue(ds2.getDocumentTemplates().contains(dt));
			}
		}
	}
}
